/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.http.client.utils;

import cn.com.duiba.cloud.duiba.http.client.response.HttpClientResponse;
import cn.com.duiba.cloud.duiba.http.client.utils.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.mock.web.MockMultipartFile;

public class HttpClientFileUtil {
    private static final String DEFAULT_PATH = "src/main/resources/httpClient";

    public static File downFile(HttpClientResponse response) {
        return HttpClientFileUtil.downFile(response, DEFAULT_PATH);
    }

    public static File downFile(HttpClientResponse response, String downPath) {
        String fileName = HttpClientFileUtil.getFileName(response);
        return FileUtil.downFile(response.getInputStream(), downPath, fileName);
    }

    public static MockMultipartFile getMockMultipartFile(HttpClientResponse response) throws IOException {
        return new MockMultipartFile(HttpClientFileUtil.getFileName(response), response.getInputStream());
    }

    private static String getFileName(HttpClientResponse response) {
        return Optional.ofNullable(HttpClientFileUtil.getHeaderFileName(response)).orElse(HttpClientFileUtil.getUrlFileName(response));
    }

    private static String getFilePath(String path, String fileName) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return fileName;
        }
        StringBuilder stringBuilder = new StringBuilder(path);
        if (path.lastIndexOf("/") != path.length()) {
            stringBuilder.append("/");
        }
        return stringBuilder.append(fileName).toString();
    }

    private static String getHeaderFileName(HttpClientResponse response) {
        String[] strings;
        String dispositionHeader = response.getHeader("Content-Disposition");
        if (StringUtils.isNotBlank((CharSequence)dispositionHeader) && (strings = dispositionHeader.split(";")).length > 1) {
            dispositionHeader = strings[1].replace("filename=", "");
            dispositionHeader = dispositionHeader.replace("fileName=", "");
            dispositionHeader = dispositionHeader.replace("\"", "");
            return dispositionHeader;
        }
        return null;
    }

    public static String getUrlFileName(HttpClientResponse response) {
        return Optional.ofNullable(response).map(HttpClientResponse::getHttpUrl).map(o -> o.substring(o.lastIndexOf("/") + 1)).orElse("HttpClientDownFile");
    }
}

