/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.http.client.utils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
public class SpringUtil
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;

    public static <T> List<T> getBeanList(Class<T> tClass) {
        Map beansOfType = applicationContext.getBeansOfType(tClass);
        ArrayList<Object> rlt = new ArrayList<Object>(beansOfType.size());
        rlt.addAll(beansOfType.values());
        rlt.sort(Comparator.comparingInt(SpringUtil::getOrder));
        return rlt;
    }

    public static <T> T getBean(Class<T> tClass) {
        return (T)applicationContext.getBean(tClass);
    }

    public static <T> T getBean(String beanName) {
        return (T)applicationContext.getBean(beanName);
    }

    public static <T> T getBean(String name, Class<T> requiredType) throws BeansException {
        return (T)applicationContext.getBean(name, requiredType);
    }

    public static int getOrder(Object o) {
        Order order = (Order)AnnotationUtils.findAnnotation(o.getClass(), Order.class);
        if (order != null) {
            return order.value();
        }
        return 0;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringUtil.applicationContext = applicationContext;
    }
}

