/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.http.client.utils;

import cn.com.duiba.cloud.duiba.http.client.annotation.HttpClient;
import cn.com.duiba.cloud.duiba.http.client.context.form.Form;
import cn.com.duiba.cloud.duiba.http.client.utils.PropertyUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class UrlUtil {
    public static String getParamUrl(String url, List<Form> nameValueParams) {
        if (nameValueParams == null || nameValueParams.isEmpty()) {
            return url;
        }
        if (!url.contains("?")) {
            url = url + "?";
        }
        int lastIndex = url.length() - 1;
        if (url.lastIndexOf("?") != lastIndex && url.charAt(lastIndex) != '&') {
            url = url + "&";
        }
        StringBuilder sb = new StringBuilder();
        for (Form nameValueParam : nameValueParams) {
            sb.append(nameValueParam.getName()).append("=").append(nameValueParam.getValue()).append("&");
        }
        return url + sb.toString();
    }

    public static String splicingUrl(String url, String path) {
        String separate = "/";
        if (url.lastIndexOf(separate) != url.length() - 1 && path.indexOf(separate) != 0) {
            url = url + separate;
        } else if (url.lastIndexOf(separate) == url.length() - 1 && path.indexOf(separate) == 0) {
            url = url.substring(0, url.length() - 1);
        }
        url = url + path;
        try {
            new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("url:\u683c\u5f0f\u9519\u8bef" + url, e);
        }
        return url;
    }

    public static String getUrl(HttpClient httpClient) {
        if (Objects.isNull(httpClient)) {
            return null;
        }
        String url = httpClient.url();
        if (StringUtils.isBlank((CharSequence)url)) {
            return null;
        }
        try {
            String propertyUrl = PropertyUtil.getProperty(url);
            return StringUtils.isBlank((CharSequence)propertyUrl) ? url : propertyUrl;
        }
        catch (Exception e) {
            return url;
        }
    }
}

