# 开放平台提供对外接口

## 1、接入开放平台

### 引入包

在**api层**引入

```
provided "cn.com.duiba.cloud:duiba-openapi-service-api:0.0.1-SNAPSHOT"
```

添加配置

```
openapi.enable=true
```

注意包扫描
由于默认情况下，api模块下的代码不会被Spring注册，需要添加一下配置。
目的为了识别，开放平台提供的注解，进行接口注册

```
@SpringBootApplication(scanBasePackages = {"cn.com.duiba.cloud"})
```


添加接口声明注解

@OpenApi ：该注解放在接口｜类上，用来识别该类对外提供开放接口
@OpenPath：该注解放在方法上，用来配置接口
如下实例：

```
@OpenApi(prefix = "/payment")
@AdvancedFeignClient("duiba-payment-service")
public interface RemoteAccountService {
    @OpenPath(apiPath = "/query/accountState",apiDesc = "查询用户账户状态信息")
    AccountStateDTO queryAccountState(AccountStateQueryParam param);

    @OpenPath(apiPath = "/query/accountBill",apiDesc = "查询账户账单接口")
    PageResponse<PayBillDTO> queryAccountBill(PayBillPageQueryParam param);
}

```


启动结果：

```
成功读取OpenApi路径：/payment/query/accountState
OpenApi注册成功：{"apiDesc":"查询用户账户状态信息","apiPath":"payment/query/accountState","className":"RemoteAccountService","method":"queryAccountState","methodParamClass":"cn.com.duiba.cloud.duiba.payment.service.api.param.AccountStateQueryParam","serviceName":"duiba-payment-service"}
成功读取OpenApi路径：/payment/query/accountBill
OpenApi注册成功：{"apiDesc":"查询账户账单接口","apiPath":"payment/query/accountBill","className":"RemoteAccountService","method":"queryAccountBill","methodParamClass":"cn.com.duiba.cloud.duiba.payment.service.api.param.PayBillPageQueryParam","serviceName":"duiba-payment-service"}
```

以上步骤会将接口注册到开放平台。

**如果需要将接口对外需要告知开放平台相关人员将接口开放状态变更。**


## 2、测试：

1、通过oauth2的密码模式获得access_token,

```
curl --location --request POST 'http://localhost:1112/access/token?grant_type=password' \
--header 'Authorization: Basic dGVzdDoxMjM0NTY=' \
--header 'Content-Type: application/json' \
--header 'Cookie: JSESSIONID=F9C3D76845589B57050E938CB635863C' \
--data-raw '{
    "appId":"test",
    "appSecret":"123456"
}'
```
2、得到access_token
```
{
    "success": true,
    "code": 1,
    "msg": "成功",
    "result": {
        "access_token": "25457143-4afd-4c6f-9da7-8b5cf419df90",
        "token_type": "bearer",
        "refresh_token": "cb254ccc-d95a-4532-8d9a-0cfd8dab8d0a",
        "expires_in": 6811,
        "scope": "all"
    }
}
```

3、通过access_token请求接口
请求参数上添加access_token参数

```
curl --location --request POST 'http://localhost:1112/openapi/payment/queryAccountBill?access_token=10497a46-7925-41e5-a090-793cdec9c906' \
--header 'Content-Type: application/json' \
--header 'Cookie: JSESSIONID=F9C3D76845589B57050E938CB635863C' \
--data-raw '{
    "sign": "445F5858242040FB3EB7CEA3975C2905",
    "param": {
        "userId": 1001,
        "pageSize": 10,
        "pageNo": 1
    }
}'
```

## 3、开放文档编写
参考
http://gitlab2.dui88.com/business_platform/duiba-openapi-web/tree/feature/20211220-openapi/apidoc

一期文档添加在该路径下，自建，以markdown格式输出


## 4、注意
> 建议底层服务在api层新增包，编写对应接口（包一下），后续需要根据应用维度进行接口隔离，提供不同的接口权限，或接口特殊处理等，最好不要和通用接口
混合在一些，否则后续很难分离。
> 
>接口写完后需要告知开放平台进行接口升级
> 
> 底层接口注意应用维度隔离，开放平台会在每个接口属性中统一塞入 appId，底层可以通过appId进行接口隔离
> 
> 所有返回和参数，都需要包装层简单对象，不能直接用基本类型