package cn.com.duiba.cloud.duiba.openapi.service.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 开放api配置
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/12/24 11:01 上午
 **/
@Data
public class OpenApiConfigDTO implements Serializable {
    /**
     * api路径
     */
    private String apiPath;

    /**
     * 接口描述
     */
    private String apiDesc;

    /**
     * 服务名
     */
    private String serviceName;

    /**
     * 类名
     */
    private String className;

    /**
     * 方法名
     */
    private String method;

    /**
     * 方法参数类
     */
    private String methodParamClass;

    /**
     * api状态（待审核、已审核待上线、已上线）
     */
    private Integer apiStatus;

    /**
     * 是否删除0-否 1-是
     */
    private Boolean isDelete;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 创建时间
     */
    private Date gmtCreate;

}
