package cn.com.duiba.cloud.duiba.openapi.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.openapi.service.api.dto.OpenApiConfigDTO;
import cn.com.duiba.cloud.duiba.openapi.service.api.param.ApiRegisterParam;

/**
 * 接口配置服务
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/12/24 10:44 上午
 **/
@AdvancedFeignClient("duiba-openapi-service")
public interface RemoteApiConfigService {

    /**
     * 更加apiPath获取该接口配置信息
     *
     * @param apiPath
     * @return
     */
    OpenApiConfigDTO getApiConfigByPath(String apiPath);


    /**
     * 接口注册, 不需手动调用，请通过注解进行注册
     * {@link cn.com.duiba.cloud.duiba.openapi.service.api.annotation.OpenApi}
     * {@link cn.com.duiba.cloud.duiba.openapi.service.api.annotation.OpenPath}
     *
     * @param registerParam
     */
    Boolean register(ApiRegisterParam registerParam) throws BizException;
}
