package cn.com.duiba.cloud.duiba.openapi.service.api.enums;

import lombok.Getter;

/**
 * @Description 充值类型枚举类
 * @Author dangcang
 * @Date 2022/5/24 1:32 下午
 **/
@Getter
public enum RechargeTypeEnum {

    COUPON("coupon","卡券"),
    TELEPHONE("telephone", "话费"),
    AMUSEMENT("amusement", "影音娱乐"),
    ADD_OIL_CARD("addOilCard", "加油卡"),
    T_MALL("tMall", "天猫淘享卡、购物券"),
    MEI_TUAN("meiTuan", "美团、大众点评"),
    NAI_SNOW("naiSnow", "奈雪直冲"),
    WECHAT_KNOCK_GOLD("wechatKnockGold", "微信立减金"),
    JD("jd", "京东充值"),
    ;

    private String code;

    private String desc;

    RechargeTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static RechargeTypeEnum getByCode(String code) {
        for (RechargeTypeEnum param : values()) {
            if (param.getCode().equals(code)) {
                return param;
            }
        }
        return null;
    }

}