package cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 扣/加积分入参
 *
 * @author sunyan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
public class CreditsRequestDTO extends RequestBaseDTO implements Serializable {
    private static final long serialVersionUID = -7878837759754241428L;
    /**
     * 积分变动发生时间戳
     */
    @NotNull(message = "changeTime 不能为空")
    private Long changeTime;
    /**
     * 扣减积分原因
     */
    @NotNull(message = "description 不能为空")
    private String description;
    /**
     * 共计变动积分
     */
    @NotNull(message = "credits 不能为空")
    private Long credits;
    /**
     * 活动订单号
     */
    private String activityOrderNum;
    /**
     * 活动/营销类型
     */
    private String activityType;
    /**
     * 活动/营销id
     */
    private String activityId;
    /**
     * 活动/营销名称
     */
    private String activityName;
    /**
     * 商品主订单号
     */
    private String orderNum;

    /**
     * 修改类型
     * CreditChangeTypeEnum - consumer
     */
    private Integer changeType;

}
