package cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto.pushang;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 加油卡请求入参
 *
 * @author zouwx
 * @date 2022/07/12
 */
@Data
public class PuShangAddOilCardReqDTO implements Serializable {

    private static final long serialVersionUID = 3180143271881264568L;

    /**
     * 类型 ZSH （中石化）、ZSY（中石油）
     */
    @NotBlank(message = "类型不能为空")
    private String type;

    /**
     * 面额
     */
    @NotBlank(message = "面额不能为空")
    private String amt;

    /**
     * 充值卡号
     */
    @NotBlank(message = "充值卡号不能为空")
    private String account;

    /**
     * 购买数量数量
     */
    @NotNull(message = "购买数量不能为空")
    private Integer number;
}
