package cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.enums;

import lombok.Getter;

/**
 * 包括税收枚举
 *
 * @author zouwx
 * @date 2022/05/25
 */
@Getter
public enum IncludeTaxEnum {

    /**
     * 状态码
     */
    INCLUDE_TAX(0,"含税"),
    NOT_TAX(1,"不含税"),
    ;

    /**
     * 标识
     */
    private Integer type;
    /**
     * 名称
     */
    private String desc;

    IncludeTaxEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }


    /**
     * 通过id获取名称
     *
     * @param id id
     * @return {@link String}
     */
    public static String getNameById(Integer id) {
        for (IncludeTaxEnum entity : IncludeTaxEnum.values()) {
            if (entity.getType().equals(id)) {
                return entity.getDesc();
            }
        }
        return null;
    }
}
