/**
 * Copyright (c) 2021- All Rights Reserved.
 */
package cn.com.duiba.cloud.duiba.openapi.service.api.enums;

import lombok.Getter;

/**
 * api状态
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/5 3:50 下午
 **/
@Getter
public enum ApiStatusEnum {
    /**
     * api状态
     */
    WAIT(1, "待审核"),
    DOING(2, "已审核待上线"),
    ONLINE(3, "已上线");

    private Integer value;

    private String desc;

    ApiStatusEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (ApiStatusEnum item : ApiStatusEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static ApiStatusEnum valueOf(Integer value) {
        for (ApiStatusEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
