package cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto.fulu;

import cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto.RechargeContextDTO;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * 福禄公共参数
 *
 * @author zouwx
 * @date 2020-07-23
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class FuLuBaseReqDTO extends RechargeContextDTO implements Serializable {

    private static final long serialVersionUID = 933388551057812892L;

    /**
     * 开放平台分配给商户的app_key
     */
    private String appKey;

    /**
     * 接口方法名称
     */
    private String method;

    /**
     * 时间戳，格式为：yyyy-MM-dd HH:mm:ss
     */
    private String timestamp;

    /**
     * 调用的接口版本
     */
    private String version;

    /**
     * 接口请求或响应格式
     */
    private String format;

    /**
     * 请求使用的编码格式，如utf-8等
     */
    private String charset;

    /**
     * 签名加密类型，目前仅支持md5
     */
    private String signType;

    /**
     * 签名
     */
    private String sign;

    /**
     * 授权码，固定值为“”
     */
    private String appAuthToken;

    /**
     * 请求参数集合（注意：该参数是以json字符串的形式传输）
     */
    private String bizContent;

    /**
     * 业务主体类型
     */
    private Long businessType;

}
