package cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto.fulu;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 话费充值请求体
 *
 * @author zouwx
 * @date 2022/05/24
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class OrderCardAddDTO extends FuLuBaseReqDTO implements Serializable {

    private static final long serialVersionUID = -2704418417841756191L;

    /**
     * 商品id
     */
    @NotBlank(message = "商品编码不能为空")
    private String productId;

    /**
     * 客户订单编号
     */
    @NotBlank(message = "订单号不能为空")
    private String customerOrderNo;

    /**
     * 购买数量
     */
    @NotBlank(message = "购买数量不能为空")
    private Integer buyNum;


}
