package cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto.BaseRechargeQueryDTO;
import cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto.RechargeResponseDTO;
import cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto.pushang.PuShangPhoneReqDTO;
import cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto.pushang.PuShangQueryOrderDTO;
import cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto.pushang.PuShangVideoReqDTO;

/**
 * 远程浦上服务
 *
 * @author zouwx
 * @date 2022/05/25
 */
@AdvancedFeignClient
public interface RemotePuShangService {

    /**
     * 影音娱乐直冲
     *
     * @param puShangVideoReqDTO 聚氨酯商视频点播dto
     * @return 只表明openApi处理了请求 并不表示充值成功
     * @throws BizException 业务异常
     */
    Boolean amusementRecharge(PuShangVideoReqDTO puShangVideoReqDTO) throws BizException;

    /**
     * 话费充值
     *
     * @param puShangPhoneReqDTO 聚氨酯商电话要求dto
     * @return {@link Boolean}
     * @throws BizException 业务异常
     */
    Boolean phoneRecharge(PuShangPhoneReqDTO puShangPhoneReqDTO) throws BizException;

    /**
     * 订单状态查询
     *
     * @param queryOrderDTO 查询订单dto
     * @return {@link RechargeResponseDTO}
     * @throws BizException 业务异常
     */
    RechargeResponseDTO queryAmusementOrder(PuShangQueryOrderDTO queryOrderDTO) throws BizException;

    /**
     * 查询话费充值订单
     *
     * @param queryDTO 查询dto
     * @return {@link RechargeResponseDTO}
     * @throws BizException 业务异常
     */
    RechargeResponseDTO queryPhoneOrder(PuShangQueryOrderDTO queryDTO) throws BizException;
}
