package cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto.CreditsRequestDTO;
import cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto.NotifyRequestDTO;
import cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto.OldVirtualCallbackDTO;
import cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto.VirtualRequestDTO;

/**
 * 第三方交互接口（扣/加积分，通知等）
 * @author sunyan
 */
@AdvancedFeignClient
public interface RemoteThirdpartyService {

    /**
     * 扣积分
     * @param creditsRequestDTO
     * @return
     */
    Boolean subCredits(CreditsRequestDTO creditsRequestDTO) throws BizException;

    /**
     * 加积分
     * @param creditsRequestDTO
     * @return
     */
    Boolean addCredits(CreditsRequestDTO creditsRequestDTO) throws BizException ;

    /**
     * 充值下单
     * @param virtualRequestDTO
     * @return
     */
    Boolean submitVirtual(VirtualRequestDTO virtualRequestDTO) throws BizException ;

    /**
     * 结果通知
     * @param notifyRequestDTO
     */
    void notifyDeveloper(NotifyRequestDTO notifyRequestDTO) throws BizException ;

    /**
     * 1。0兼容回调
     * @param oldVirtualCallbackDTO
     */
    void oldVirtualCallback(OldVirtualCallbackDTO oldVirtualCallbackDTO);


}
