package cn.com.duiba.cloud.duiba.openapi.service.api.constants;


/**
 * <p>
 * 事件常量
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/12/06 9:58 上午
 **/
public class OpenApiConstant {

    /**
     * 开放平台事件
     */
    public static final String OPEN_API_TOPIC = "duiba-open-api-event";

    public static String buildDestination(String eventType) {
        return OPEN_API_TOPIC + ":" + eventType;
    }

    /**
     * 路由参数
     */
    public interface RouteParam {

        /**
         * api配置
         */
        String API_CONFIG = "apiConfig";

        /**
         * 参数
         */
        String PARAM = "param";
    }
}
