/**
 * Copyright (c) 2021- All Rights Reserved.
 */
package cn.com.duiba.cloud.duiba.openapi.service.api.enums;

import lombok.Getter;

/**
 * 开放事件传播类型
 * <p>
 * Topic: duiba-open-api-event
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/14 3:50 下午
 **/
@Getter
public enum OpenEventSpreadEnum {
    /**
     * 事件状态
     */
    BROADCAST(1, "广播"),
    DIRECTIONAL(2, "定向"),
    ;

    private Integer value;

    private String desc;

    OpenEventSpreadEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (OpenEventSpreadEnum item : OpenEventSpreadEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static OpenEventSpreadEnum valueOf(Integer value) {
        for (OpenEventSpreadEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
