/**
 * Copyright (c) 2021- All Rights Reserved.
 */
package cn.com.duiba.cloud.duiba.openapi.service.api.enums;

import lombok.Getter;

/**
 * 开放事件传播类型
 * <p>
 * Topic: duiba-open-api-event
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/14 3:50 下午
 **/
@Getter
public enum OpenEventStrategyEnum {
    /**
     * 弱消息，至多只会通知两次，不管是否通知到
     */
    weak(1, "弱消息"),

    /**
     * 强消息，会一直通知，直达送达，依赖于MQ的策略
     */
    strong(2, "强消息"),
    ;

    private Integer value;

    private String desc;

    OpenEventStrategyEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (OpenEventStrategyEnum item : OpenEventStrategyEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static OpenEventStrategyEnum valueOf(Integer value) {
        for (OpenEventStrategyEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
