package cn.com.duiba.cloud.duiba.openapi.service.api.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @Description 供应商code枚举类
 * @Author dangcang
 * @Date 2022/5/24 12:00 下午
 **/
@Getter
public enum SupplierCodeEnum {

    XIANGSHNG("xiangshang", "向上"),
    PUSHANG("pushang", "浦上"),
    FULU("fulu", "福禄"),

    ;

    private String code;

    private String desc;

    SupplierCodeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static SupplierCodeEnum getByCode(String code) {
        for (SupplierCodeEnum supplierCodeEnum : SupplierCodeEnum.values()) {
            if (Objects.equals(code, supplierCodeEnum.getCode())) {
                return supplierCodeEnum;
            }
        }
        return null;
    }

}