package cn.com.duiba.cloud.duiba.openapi.service.api.param;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 目录item
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/3/2 3:38 下午
 **/
@Data
@EqualsAndHashCode(callSuper = true)
public class DocumentQueryParam extends PageRequest {

    private static final long serialVersionUID = -4073604148413400897L;
    /**
     * 父类id，第一层0
     */
    private Long parentId;

    /**
     * 文档类型
     *
     * @see cn.com.duiba.cloud.duiba.openapi.service.api.enums.OpenDocumentTypeEnum
     */
    private Integer documentType;

    /**
     * 展示类型
     * 0-目录 1-文档
     */
    private Integer showType;

    /**
     * 文档状态
     *
     * @see cn.com.duiba.cloud.duiba.openapi.service.api.enums.OpenCommonStatusEnum
     */
    private Integer documentStatus;


    /**
     * 字段类型 0-id desc;1-showOrder,gmtCreate desc;
     */
    private Integer orderType;

    private Boolean isDelete;
}
