package cn.com.duiba.cloud.duiba.openapi.service.api.param;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * api文档
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/03/02 11:01 上午
 **/
@Data
public class DocumentSaveParam implements Serializable {
    private static final long serialVersionUID = 4406896128715402448L;

    /**
     * 标题
     */
    @NotNull(message = "id不能为空")
    private String title;

    /**
     * 展示排序（编号越大越靠前,相同情况按创建时间排序）
     */
    @NotNull(message = "排序编号不能为空")
    private Integer showOrder;

    /**
     * 展示类型
     * 0-目录 1-文档
     */
    private Integer showType;

    /**
     * 文档类型
     */
    @NotNull(message = "文档类型不能为空")
    private Integer documentType;

    /**
     * 父类id
     */
    @NotNull(message = "id不能为空")
    private Long parentId;
}