package cn.com.duiba.cloud.duiba.openapi.service.api.param;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 限流列表查询
 * @author huangguosheng@duiba.com.cn
 * @date 2022/3/2 1:54 下午
 **/
@Data
public class FLowLimitSaveParam implements Serializable {
    private static final long serialVersionUID = -1105899955707384568L;

    /**
     * api接口路径
     */
    @NotNull(message = "接口路径不能为空")
    private String apiPath;

    /**
     * appKey
     */
    @NotNull(message = "appKey不能为空")
    private String appKey;

    /**
     * 阈值
     */
    @NotNull(message = "阈值不能为空")
    private Integer threshold;

    /**
     * 限流模式（0-单机 1-集群）
     */
    @NotNull(message = "限流模式不能为空")
    private Integer limitType;

    /**
     * 阈值类型(0-并发线程数 1-QPS )
     */
    @NotNull(message = "阈值类型不能为空")
    private Integer thresholdType;
}
