package cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto;

import cn.com.duiba.cloud.duiba.openapi.service.api.enums.RechargeTypeEnum;
import cn.com.duiba.cloud.duiba.openapi.service.api.enums.SupplierCodeEnum;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @Description 充值上下文
 * @Author dangcang
 * @Date 2022/5/24 1:54 下午
 **/
@Data
public class RechargeContextDTO implements Serializable {

    private static final long serialVersionUID = -3384934357544419544L;

    /**
     * 充值类型
     * @see RechargeTypeEnum
     */
    @NotNull(message = "充值类型不能为空")
    private String rechargeType;

    /**
     * 供应商类型
     * @see SupplierCodeEnum
     */
    @NotNull(message = "供应商类型不能为空")
    private String supplierType;

    /**
     * 主订单号
     */
    @NotBlank(message = "业务订单号不能为空")
    private String mainOrderNum;

    /**
     * 业务主体类型
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.BusinessEntityEnum
     */
    @NotNull(message = "业务主体类型不能为空")
    private Long businessType;

    /**
     * 应用程序id
     */
    @NotNull(message = "appId不能为空")
    private Long appId;

    /**
     * 子订单编号
     */
    @NotNull(message = "子订单号不能为空")
    private List<String> orderSortList;

    /**
     * 是否含税
     * @see cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.enums.IncludeTaxEnum
     */
    private Integer includeTax;

    /**
     * mq回调topic
     * 回调消息都是
     * @see cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto.RechargeResponseDTO
     */
    private String callbackTopic;

    /**
     * mq回调tag
     */
    private String callbackTag;

    /**
     * mq回调key
     */
    private String callbackKey;
}