package cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto;

import cn.com.duiba.cloud.duiba.openapi.service.api.enums.RechargeTypeEnum;
import cn.com.duiba.cloud.duiba.openapi.service.api.enums.SupplierCodeEnum;
import cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto.fulu.FuLuCardListDTO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2022/5/24 2:56 下午
 **/
@Data
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
public class RechargeResponseDTO extends ResponseBaseDTO implements Serializable {

    /**
     * 已完成
     */
    public static final String SUCCESS = "success";

    /**
     * 失败
     */
    public static final String FAIL = "fail";

    /**
     * 处理中
     */
    public static final String PROCESS = "process";

    /**
     * 内部主订单号
     */
    private String orderNum;

    /**
     * 子订单号
     */
    private List<String> orderSortList;

    /**
     * 外部第三方订单号
     */
    private String thirdOrderNum;

    /**
     * 见上静态变量
     */
    private String status;

    /**
     * 订单结果之外的特殊数据
     * 1-福禄卡券卡号卡密数据
     * @see FuLuCardListDTO
     */
    private Object orderResultData;

    /**
     * 充值类型
     * @see RechargeTypeEnum
     */
    private String rechargeType;

    /**
     * 供应商类型
     * @see SupplierCodeEnum
     */
    private String supplierType;
}