package cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Map;

/**
 * @author sunyan
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class RequestBaseDTO implements Serializable {

    private static final long serialVersionUID = 6579000080665829632L;
    /**
     * 外部用户id
     */
    @NotNull(message = "uid 不能为空")
    private String uid;
    /**
     * appKey
     */
    @NotNull(message = "appId 不能为空")
    private Long appId;
    /**
     * 时间戳
     */
    private Long timestamp = System.currentTimeMillis();
    /**
     * 开发者回传参数
     */
    private String transfer;
    /**
     * 扩展参数
     */
    private Map<String, String> extParams;

    /**
     * mq回调topic
     */
    private String callbackTopic;
    /**
     * mq回调tag
     */
    private String callbackTag;
    /**
     * mq回调key
     */
    private String callbackKey;
}
