package cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
/**
 * 充值下单入参
 * @author sunyan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
public class VirtualRequestDTO extends RequestBaseDTO implements Serializable {
    private static final long serialVersionUID = 1555591764066303123L;
    /**
     * 开发者订单号
     */
    private String developBizId;
    /**
     * 文案描述
     */
    @NotNull(message = "description 不能为空")
    private String description;
    /**
     * 商品主订单号
     */
    @NotNull(message = "orderNum 不能为空")
    private String orderNum;
    /**
     * 子订单号
     */
    private String subOrderNum;
    /**
     * 商品名称
     */
    private String goodsName;
    /**
     * 商品属性
     */
    private String goodsAttribute;
    /**
     * 商品数量
     */
    private Long goodsCount;
    /**
     * sku编码
     */
    @NotNull(message = "skuCode 不能为空")
    private String skuCode;
    /**
     * 用户兑换充值商品时输入的账号，只有在打开充值商品账号输入开关时，会传输此参数。
     */
    private String account;
}
