package cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto;

import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Description 话费充值参数类
 * @Author dangcang
 * @Date 2022/5/24 11:00 上午
 **/
@Data
public class XiangshangTelephoneRechargeRequestDTO implements Serializable {

    private static final long serialVersionUID = -8313663135193565343L;

    /**
     * 话费充值账号
     */
    @NotBlank(message = "充值账号不能为空")
    private String account;

    /**
     * 商品数量
     */
    @Min(1)
    @NotNull(message = "充值数量不能为空")
    private Long goodsCount;

    /**
     * sku编码
     */
    @NotBlank(message = "供应商商品编码不能为空")
    private String skuCode;

}