package cn.com.duiba.cloud.order.center.api.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @Description 订单状态枚举类
 * @Author dangcang
 * @Date 2021/11/8 2:13 下午
 **/
@Getter
public enum OrderStatusEnum {

    INIT(0, "初始状态，仅用于根据订单类型创建参数"),
    AFTER_BUILD_PARAM_PURCHASE(1, "第三方下单"),
    /**
     * 主订单状态在 待支付-待审核之后 会转到待完成 直到所有的子订单状态都到终态
     */
    WAIT_COMPLETION(5, "待完成"),

    WAIT_PAY(10,"待支付"),
    PAID(15, "已支付"),
    WAIT_REVIEW(20,"待审核"),
    WAIT_SHIPMENT(30,"待发货"),
    WAIT_TAKE_DELIVERY(40,"待收货"),
    ORDER_COMPLETION(50,"交易完成"),

    ORDER_SUCCESS(90,"交易成功"),
    ORDER_CLOSE(91,"交易关闭"),
    ORDER_ERROR(99,"异常状态"),
    ;

    private Integer status;

    private String desc;

    OrderStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    private static Map<Integer, OrderStatusEnum> map = new HashMap<Integer, OrderStatusEnum>() {{
        for (OrderStatusEnum statusEnum : OrderStatusEnum.values()) {
            put(statusEnum.getStatus(), statusEnum);
        }
    }};

    private static Map<String, OrderStatusEnum> descMap = new HashMap<String, OrderStatusEnum>() {{
        for (OrderStatusEnum statusEnum : OrderStatusEnum.values()) {
            put(statusEnum.getDesc(), statusEnum);
        }
    }};

    public static OrderStatusEnum getByStatus(Integer status) {
        return map.get(status);
    }

    public static OrderStatusEnum getByDesc(String desc) {
        return descMap.get(desc);
    }

}