package cn.com.duiba.cloud.order.center.api.model.dto.order;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2022/1/6 9:40 上午
 **/
@Data
@EqualsAndHashCode(callSuper = true)
public class SubOrderPageDTO extends SubOrderDTO implements Serializable {

    private static final long serialVersionUID = 5780503633844580929L;

    /**
     * 提供下次查询时的scrollId scroll查询时返回此字段,
     */
    private String scrollId;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 下单时间
     */
    private Long orderTime;

    /**
     * 订单类型
     */
    private Integer orderType;

    /**
     * 售后状态
     */
    private Integer afterSaleStatus;

    /**
     * 购买人id
     */
    private Long buyerId;

    /**
     * 购买人类型
     */
    private Integer buyerType;

    /**
     * 销售人id
     */
    private Long sellerId;

    /**
     * 销售人类型
     */
    private Integer sellerType;

    /**
     * 订单地址信息
     */
    private ReceiverUserDTO receiverUserDTO;

    /**
     * 扩展信息查询
     */
    private List<OrderExtraDTO> orderExtraDTOS;
}