package cn.com.duiba.cloud.order.center.api.model.param.order;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description 订单查询参数
 * @Author dangcang
 * @Date 2021/11/10 3:05 下午
 **/
@Getter
@Setter
public class OrderQueryParam extends PageRequest implements Serializable {

    private static final long serialVersionUID = 8035926659649749486L;

    /**
     * 使用游标查询 非导出请勿使用
     */
    private boolean useScroll = false;

    /**
     * 提供下次查询时的scrollId scroll查询时返回此字段,
     */
    private String scrollId;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 买家id
     */
    private Long buyerId;

    /**
     * 买家类型
     */
    private Integer buyerType;

    /**
     * 卖家id
     */
    private Long sellerId;

    /**
     * 卖家类型
     */
    private Integer sellerType;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 下单开始时间 毫秒级时间戳
     */
    private Date orderStartTime;

    /**
     * 下单截止时间 毫秒级时间戳
     */
    private Date orderEndTime;

    /**
     * 订单来源
     */
    private String orderSource;

    /**
     * 商品类型
     */
    private Integer goodsType;

    /**
     * 商品来源
     */
    private Integer goodsSource;

    /**
     * 订单类型
     */
    private Integer orderType;

    /**
     * 订单状态
     */
    private Integer orderStatus;
}