package cn.com.duiba.cloud.order.center.api.openapi;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.openapi.service.api.annotation.OpenApi;
import cn.com.duiba.cloud.duiba.openapi.service.api.annotation.OpenPath;
import cn.com.duiba.cloud.order.center.api.model.dto.order.ConfirmOrderParam;
import cn.com.duiba.cloud.order.center.api.model.dto.order.PayDTO;
import cn.com.duiba.cloud.order.center.api.model.dto.order.UserOrderDetailDTO;
import cn.com.duiba.cloud.order.center.api.model.param.order.CancelOrderParam;
import cn.com.duiba.cloud.order.center.api.model.param.order.OrderRemindParam;
import cn.com.duiba.cloud.order.center.api.openapi.model.dto.BoolDTO;
import cn.com.duiba.cloud.order.center.api.openapi.model.param.OpenOrderCreateParam;
import cn.com.duiba.cloud.order.center.api.openapi.model.param.OpenOrderPageQueryParam;
import cn.com.duiba.cloud.order.center.api.openapi.model.param.OpenOrderQueryParam;

/**
 * 供应商定
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/1/12 3:28 下午
 **/
@OpenApi(prefix = "/supplier/order")
@AdvancedFeignClient("duiba-order-center")
public interface SupplierOrderService {

    @OpenPath(apiPath = "/create", apiDesc = "订单创建")
    PayDTO orderCreate(OpenOrderCreateParam param) throws BizException;

    @OpenPath(apiPath = "/confirm", apiDesc = "订单确认")
    BoolDTO orderConfirm(ConfirmOrderParam param) throws BizException;

    @OpenPath(apiPath = "/cancel", apiDesc = "订单确认")
    BoolDTO orderCancel(CancelOrderParam param) throws BizException;

    void orderDone();


    BoolDTO userOrderRemind(OrderRemindParam param) throws BizException;


    UserOrderDetailDTO queryOrderByDetail(OpenOrderQueryParam param) throws BizException;

    void queryOrderForPage(OpenOrderPageQueryParam param);


    void orderSignForSale();

    void orderLogisticsQuery();

    void deliverReminder();

}
