package cn.com.duiba.cloud.order.center.api.openapi.model.param;

import cn.com.duiba.cloud.order.center.api.model.param.order.DiscountParam;
import cn.com.duiba.cloud.order.center.api.model.param.order.GoodsParam;
import cn.com.duiba.cloud.order.center.api.model.param.order.ReceiverUserParam;
import cn.com.duiba.cloud.order.center.api.model.param.order.UserParam;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Description 创建订单
 * @Author dangcang
 * @Date 2021/11/10 1:57 下午
 **/
@Data
public class OpenOrderCreateParam implements Serializable {

    private static final long serialVersionUID = 7843442537905425984L;


    /**
     * 地址id
     */
    private Long addressId;

    /**
     * 收货人信息
     */
    private ReceiverUserParam receiverUserParam;

    /**
     * appId
     */
    private Long appId;

    /**
     * 来源 和orderType确定
     */
    private String orderSource;

    /**
     * 用户信息相关
     */
    private UserParam userParam;

    /**
     * 商品相关
     */
    private List<GoodsParam> goodsParams;

    /**
     * 优惠相关
     */
    private List<DiscountParam> discountParams;
}