/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.order.center.api.enums;

import java.util.HashMap;
import java.util.Map;

public enum OrderStatusEnum {
    INIT(0, "\u521d\u59cb\u72b6\u6001,\u4ec5\u7528\u4e8e\u6839\u636e\u8ba2\u5355\u7c7b\u578b\u521b\u5efa\u53c2\u6570"),
    AFTER_CREATE_ORDER(1, "\u6784\u5efa\u53c2\u6570\u4e4b\u540e,\u521b\u5efa\u8ba2\u5355\u4e4b\u524d"),
    WAIT_COMPLETION(5, "\u5f85\u5b8c\u6210"),
    WAIT_PAY(10, "\u5f85\u652f\u4ed8"),
    PAID(15, "\u5df2\u652f\u4ed8"),
    WAIT_REVIEW(20, "\u5f85\u5ba1\u6838"),
    WAIT_SHIPMENT(30, "\u5f85\u53d1\u8d27"),
    WAIT_TAKE_DELIVERY(40, "\u5f85\u6536\u8d27"),
    ORDER_COMPLETION(50, "\u4ea4\u6613\u5b8c\u6210"),
    ORDER_SUCCESS(90, "\u4ea4\u6613\u6210\u529f"),
    ORDER_CLOSE(91, "\u4ea4\u6613\u5173\u95ed"),
    ORDER_ERROR(99, "\u5f02\u5e38\u72b6\u6001");

    private Integer status;
    private String desc;
    private static Map<Integer, OrderStatusEnum> map;
    private static Map<String, OrderStatusEnum> descMap;

    private OrderStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public static OrderStatusEnum getByStatus(Integer status) {
        return map.get(status);
    }

    public static OrderStatusEnum getByDesc(String desc) {
        return descMap.get(desc);
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        map = new HashMap<Integer, OrderStatusEnum>(){
            {
                for (OrderStatusEnum statusEnum : OrderStatusEnum.values()) {
                    this.put(statusEnum.getStatus(), statusEnum);
                }
            }
        };
        descMap = new HashMap<String, OrderStatusEnum>(){
            {
                for (OrderStatusEnum statusEnum : OrderStatusEnum.values()) {
                    this.put(statusEnum.getDesc(), statusEnum);
                }
            }
        };
    }
}

