package cn.com.duiba.cloud.order.center.api.openapi.model.param;

import lombok.Data;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2022/1/25 3:47 下午
 **/
@Data
public class OpenCreateLogisticsParam implements Serializable {

    private static final long serialVersionUID = -165723484374378879L;
    /**
     * 该物流单所运输的子订单序号
     */
    @NotEmpty(message = "子订单序号不能为空")
    private List<Long> orderSort;

    /**
     * 快递公司
     */
    @NotEmpty(message = "快递公司不能为空")
    /**
     * @see cn.com.duiba.cloud.order.center.api.enums.ExpressCodeEnum
     */
    private String logisticsCompany;

    /**
     * 物流单号
     */
    @NotEmpty(message = "物流单号不能为空")
    private String logisticsNo;

    /**
     * 运费 分 默认0
     */
    private Long freight = 0L;
}