package cn.com.duiba.cloud.order.center.api.openapi.model.param;

import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @Description 创建订单
 * @Author dangcang
 * @Date 2021/11/10 1:57 下午
 **/
@Data
public class OpenOrderCreateParam implements Serializable {

    private static final long serialVersionUID = 7843442537905425984L;

    /**
     * 地址id 和下方的收货人信息二选一
     */
    private Long addressId;

    /**
     * 收货人信息
     */
    private OpenReceiverUserParam receiverUserParam;

    /**
     * 第三方订单编号
     */
    @NotBlank(message = "第三订单号不能为空")
    private String thirdOrderCode;

    /**
     * 商品相关
     */
    @Valid
    @NotEmpty(message = "商品信息不能为空")
    private List<OpenGoodsParam> goodsParams;

    /**
     * 应用上下文参数
     */
    @NotNull(message = "应用上下文参数不能为空")
    private ApiContext apiContext;
}