package cn.com.duiba.cloud.order.center.api.openapi;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.openapi.service.base.annotation.OpenApi;
import cn.com.duiba.cloud.openapi.service.base.annotation.OpenPath;
import cn.com.duiba.cloud.order.center.api.openapi.model.dto.OpenAfterSaleDTO;
import cn.com.duiba.cloud.order.center.api.openapi.model.dto.OpenBoolDTO;
import cn.com.duiba.cloud.order.center.api.openapi.model.dto.OpenPayDTO;
import cn.com.duiba.cloud.order.center.api.openapi.model.param.OpenBatchDeliverGoodsParam;
import cn.com.duiba.cloud.order.center.api.openapi.model.param.OpenBatchUpdateLogisticsParam;
import cn.com.duiba.cloud.order.center.api.openapi.model.param.OpenCancelOrderParam;
import cn.com.duiba.cloud.order.center.api.openapi.model.param.OpenConfirmOrderParam;
import cn.com.duiba.cloud.order.center.api.openapi.model.param.OpenCreateAfterSaleParam;
import cn.com.duiba.cloud.order.center.api.openapi.model.param.OpenOrderCreateParam;
import cn.com.duiba.cloud.order.center.api.openapi.model.param.OpenOrderSuccessParam;
import cn.com.duiba.cloud.order.center.api.openapi.model.param.OpenUpdateAfterSaleParam;

/**
 * 供应商定
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/1/12 3:28 下午
 **/
@OpenApi(prefix = "/supplier/order")
@AdvancedFeignClient
public interface OpenSupplierOrderService {

    @OpenPath(apiPath = "/create", apiDesc = "订单创建")
    OpenPayDTO orderCreate(OpenOrderCreateParam param) throws BizException;

    @OpenPath(apiPath = "/confirm", apiDesc = "订单确认收货")
    OpenBoolDTO orderConfirm(OpenConfirmOrderParam param) throws BizException;

    @OpenPath(apiPath = "/batch/goods_delivery", apiDesc = "订单发货")
    OpenBoolDTO batchGoodsDelivery(OpenBatchDeliverGoodsParam param) throws BizException;

    @OpenPath(apiPath = "/batch/goods_delivery/update", apiDesc = "修改订单物流")
    OpenBoolDTO batchGoodsDeliveryUpdate(OpenBatchUpdateLogisticsParam param) throws BizException;

    @OpenPath(apiPath = "/cancel", apiDesc = "订单取消")
    OpenBoolDTO orderCancel(OpenCancelOrderParam param) throws BizException;

    @OpenPath(apiPath = "/create/after_sale", apiDesc = "申请售后")
    OpenAfterSaleDTO createAfterSale(OpenCreateAfterSaleParam param) throws BizException;

    @OpenPath(apiPath = "/update/after_sale/status", apiDesc = "修改售后单状态")
    OpenBoolDTO updateAfterSaleStatus(OpenUpdateAfterSaleParam param) throws BizException;

    @OpenPath(apiPath = "/success", apiDesc = "修改订单状态到终态")
    OpenBoolDTO orderSuccess(OpenOrderSuccessParam param) throws BizException;
}
