package cn.com.duiba.cloud.order.center.api.model.param.order;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Description 创建订单
 * @Author dangcang
 * @Date 2021/11/10 1:57 下午
 **/
@Data
public class OrderCreateParam implements Serializable {

    private static final long serialVersionUID = 1260557828431632752L;
    /**
     * 订单类型
     * @see cn.com.duiba.cloud.order.center.api.enums.OrderTypeEnum
     */
    private Integer orderType;

    /**
     * 当存在实物商品时 地址id 和收货人信息不能同时为空
     * 建议 传入收货人信息而不是地址Id
     * 防止创建时并发修改地址的问题
     * @see cn.com.duiba.cloud.duiba.goods.center.api.constant.SpuTypeEnum
     */
    @Deprecated
    private Long addressId;

    /**
     * 收货人信息 活动订单可不传在后续支付结果接口传入
     */
    private ReceiverUserParam receiverUserParam;

    /**
     * 来源 和orderType确定
     * 比如活动订单传入活动id
     */
    private String orderSource;

    /**
     * 来源类型 文字信息 和orderType确定
     * 比如活动类型传入大转盘
     */
    private String orderSourceType;

    /**
     * 第三方订单号 现在只有活动订单 orderType = 5有需要记录扣积分订单号
     */
    private String thirdOrderCode;

    /**
     * 终端环境
     */
    private String environment = "UnKnow";

    /**
     * 用户信息相关
     */
    private UserParam userParam;

    /**
     * 商品相关
     */
    private List<GoodsParam> goodsParams;
}