package cn.com.duiba.cloud.order.center.api.openapi.model.param;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @Description 取消订单
 * @Author dangcang
 * @Date 2021/11/10 6:05 下午
 **/
@Data
public class OpenCancelOrderParam implements Serializable {

    private static final long serialVersionUID = -7184742869617957731L;
    /**
     * 订单号
     */
    @NotBlank(message = "订单号不能为空")
    private String orderCode;

    /**
     * 子订单序号相关
     */
    private List<OpenCancelOrderRollBackParam> rollBackParams;

    /**
     * 是否租户取消订单
     */
    private Boolean fromTenant = Boolean.TRUE;

    /**
     * 取消原因
     */
    @NotBlank(message = "取消原因不能为空")
    private String cancelReason;

    /**
     * 应用上下文参数
     */
    @NotNull(message = "应用上下文参数不能为空")
    private ApiContext apiContext;
}