package cn.com.duiba.cloud.order.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.order.center.api.model.param.logistics.BatchCreateDispatchBillParam;
import cn.com.duiba.cloud.order.center.api.model.param.logistics.BatchDeliverGoodsParam;
import cn.com.duiba.cloud.order.center.api.model.param.logistics.BatchUpdateLogisticsParam;
import cn.com.duiba.cloud.order.center.api.model.param.logistics.CancelDispatchBillParam;
import cn.com.duiba.cloud.order.center.api.model.param.logistics.SupplierDeliveryParam;

import java.util.List;

/**
 * @Description 物流、发货写相关
 * @Author dangcang
 * @Date 2021/11/14 10:00 上午
 **/
@AdvancedFeignClient
public interface RemoteLogisticsWriteService {

    /**
     * 批量实物发货接口
     * @param param
     * @return
     * @throws BizException
     */
    Boolean batchGoodsDelivery(BatchDeliverGoodsParam param) throws BizException;

    /**
     * 第三方供应商发货
     * @param param
     * @return
     * @throws BizException
     */
    Boolean supplierGoodsDelivery(SupplierDeliveryParam param) throws BizException;

    /**
     * 批量创建发货单
     * @param params
     * @return
     * @throws BizException
     */
    Boolean batchCreateDispatchBill(List<BatchCreateDispatchBillParam> params) throws BizException;

    /**
     * 批量更新物流信息
     * @param param
     * @return
     * @throws BizException
     */
    Boolean batchUpdateLogistics(BatchUpdateLogisticsParam param) throws BizException;

    /**
     * 取消发货单
     * @param param
     * @return
     * @throws BizException
     */
    Boolean cancelDispatchBillParam(CancelDispatchBillParam param) throws BizException;
}