package cn.com.duiba.cloud.order.center.api.model.param.order;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2022/1/6 9:56 上午
 **/
@Data
@EqualsAndHashCode(callSuper = true)
public class SubOrderQueryParam extends PageRequest implements Serializable {

    private static final long serialVersionUID = 5898467824513542832L;

    /**
     * 使用游标查询 非导出请勿使用
     */
    private boolean useScroll = false;

    /**
     * 是否为兑吧查询
     */
    private Boolean fromDuibaQuery = false;

    /**
     * 提供下次查询时的scrollId scroll查询时返回此字段,
     */
    private String scrollId;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 子订单序号
     */
    private Long orderSort;

    /**
     * 子订单号列表
     */
    private List<Long> orderSortList;

    /**
     * 下单开始时间 毫秒级时间戳
     */
    private Long orderStartTime;

    /**
     * 下单截止时间 毫秒级时间戳
     */
    private Long orderEndTime;

    /**
     * 发货时间开始
     */
    private Long deliveryTimeStart;

    /**
     * 发货时间结束
     */
    private Long deliveryTimeEnd;

    /**
     * 买家id
     */
    private Long buyerId;

    /**
     * 买家类型
     */
    private Integer buyerType;

    /**
     * 购买方appId
     */
    private Long buyerAppId;

    /**
     * 卖家id
     */
    private Long sellerId;

    /**
     * 卖家类型
     */
    private Integer sellerType;

    /**
     * 销售方appId
     */
    private Long sellerAppId;

    /**
     * 订单来源
     */
    private String orderSource;

    /**
     * 商品类型
     */
    private Integer goodsType;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 商品来源
     */
    private Integer goodsSource;

    /**
     * 订单类型
     */
    private Integer orderType;

    /**
     * 第三方订单号
     */
    private String thirdOrderCode;

    /**
     * 订单状态
     */
    private Integer subOrderStatus;

    /**
     * 订单状态列表
     */
    private List<Integer> subOrderStatusList;

    /**
     * 售后状态
     */
    private Integer afterSaleStatus;

    /**
     * 售后单号
     */
    private String afterSaleCode;
}