package cn.com.duiba.cloud.order.center.api.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @Description 订单类型枚举类
 * @Author dangcang
 * @Date 2021/11/8 2:04 下午
 **/
@Getter
public enum OrderTypeEnum {

    EXCHANGE(1,"兑换订单:还没用到 后续逻辑来了可能要改"),
    NORMAL(2, "普通toC订单:还没开发"),
    SALE(3, "toB销售订单:关联B2B采购订单"),
    PURCHASE(4, "B2B采购订单"),
    ACTIVITY(5, "活动订单:关联活动销售订单:toC"),
    ACTIVITY_SALE(6, "活动销售订单:关联活动采购订单"),
    ACTIVITY_PURCHASE(7, "活动采购订单"),
    ;

    private Integer type;

    private String desc;

    OrderTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static Map<Integer, OrderTypeEnum> map = new HashMap<Integer, OrderTypeEnum>() {{
        for (OrderTypeEnum orderTypeEnum : OrderTypeEnum.values()) {
            put(orderTypeEnum.getType(), orderTypeEnum);
        }
    }};

    public static OrderTypeEnum getByType(Integer type) {
        return map.get(type);
    }
}