package cn.com.duiba.cloud.order.center.api.enums;

import com.google.common.collect.Lists;
import lombok.Getter;

import java.util.List;
import java.util.Objects;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2022/1/7 5:51 下午
 **/
@Getter
public enum PurchaseOrderAdapterStatusEnum {

    ALL(1, "全部", Lists.newArrayList(OrderStatusEnum.WAIT_SHIPMENT.getStatus(),
            OrderStatusEnum.WAIT_TAKE_DELIVERY.getStatus(), OrderStatusEnum.ORDER_COMPLETION.getStatus(),
            OrderStatusEnum.ORDER_SUCCESS.getStatus(), OrderStatusEnum.ORDER_CLOSE.getStatus())),
    WAIT_SHIPMENT(2,"待发货", Lists.newArrayList(OrderStatusEnum.WAIT_SHIPMENT.getStatus())),
    WAIT_TAKE_DELIVERY(3,"待收货", Lists.newArrayList(OrderStatusEnum.WAIT_TAKE_DELIVERY.getStatus())),
    ORDER_SUCCESS(4,"交易成功", Lists.newArrayList(OrderStatusEnum.ORDER_COMPLETION.getStatus(), OrderStatusEnum.ORDER_SUCCESS.getStatus())),
    ORDER_CLOSE(5,"交易关闭", Lists.newArrayList(OrderStatusEnum.ORDER_CLOSE.getStatus())),
    ;

    private Integer status;

    private String desc;

    private List<Integer> adapterStatus;

    PurchaseOrderAdapterStatusEnum(Integer status, String desc, List<Integer> adapterStatus) {
        this.status = status;
        this.desc = desc;
        this.adapterStatus = adapterStatus;
    }

    public static PurchaseOrderAdapterStatusEnum getPurchaseOrderStatusAdapterEnum(OrderStatusEnum orderStatusEnum){
        for (PurchaseOrderAdapterStatusEnum value : PurchaseOrderAdapterStatusEnum.values()) {
            if (Objects.equals(PurchaseOrderAdapterStatusEnum.ALL.getStatus(), value.getStatus())) {
                continue;
            }
            if (value.getAdapterStatus().contains(orderStatusEnum.getStatus())) {
                return value;
            }
        }
        return null;
    }

    public static List<Integer> getOrderStatus(Integer purchaseOrderAdapterStatus){
        for (PurchaseOrderAdapterStatusEnum value : PurchaseOrderAdapterStatusEnum.values()) {
            if (Objects.equals(value.getStatus(), purchaseOrderAdapterStatus)) {
                return value.getAdapterStatus();
            }
        }
        return null;
    }
}