package cn.com.duiba.cloud.order.center.api.model.dto.aftersale;

import cn.com.duiba.cloud.order.center.api.model.dto.order.PaymentDTO;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Description 售后单详情
 * @Author dangcang
 * @Date 2021/11/11 10:12 上午
 **/
@Data
public class AfterSaleDetailDTO implements Serializable {

    private static final long serialVersionUID = 8410272143992204277L;
    /**
     * 商品图片
     */
    private String goodsImgSrc;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 购买数量
     */
    private Long saleNumber;

    /**
     * 付款信息
     */
    private List<PaymentDTO> paymentDTOList;

    /**
     * 售后单号
     */
    private Long afterSaleId;

    /**
     * 申请时间 毫秒级时间戳
     */
    private Long createTime;

    /**
     * 售后完成时间 毫秒级时间戳
     */
    private Long successTime;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 用户类型
     */
    private Integer userType;

    /**
     * 订单号
     */
    private Long orderCode;

    /**
     * 子订单序号
     */
    private Long orderSort;

    /**
     * 订单状态
     */
    private Integer orderStatus;

    /**
     * 售后状态
     */
    private Integer afterSaleStatus;

    /**
     * 售后方式
     * @see cn.com.duiba.cloud.order.center.api.enums.AfterSaleWayEnum
     */
    private Integer afterSaleWay;

    /**
     * 售后类型
     * @see cn.com.duiba.cloud.order.center.api.enums.AfterSaleTypeEnum
     */
    private Integer afterSaleType;

    /**
     * 退款方式
     */
    private Integer refundType;

    /**
     * 售后原因
     */
    private String afterSaleReason;

    /**
     * 售后凭证
     */
    private String afterSaleImgSrc;
}