package cn.com.duiba.cloud.order.center.api.model.param.order;

import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @Description 创建订单
 * @Author dangcang
 * @Date 2021/11/10 1:57 下午
 **/
@Data
public class OrderCreateParam implements Serializable {

    public static final String UN_KNOW = "未知";

    private static final long serialVersionUID = 1260557828431632752L;
    /**
     * 订单类型
     * @see cn.com.duiba.cloud.order.center.api.enums.OrderTypeEnum
     */
    @NotNull(message = "订单类型不能为空")
    private Integer orderType;

    /**
     * 当存在实物商品时 地址id 和收货人信息不能同时为空
     * 建议 传入收货人信息而不是地址Id
     * 防止创建时并发修改地址的问题
     * @see cn.com.duiba.cloud.duiba.goods.center.api.constant.SpuTypeEnum
     */
    @Deprecated
    private Long addressId;

    /**
     * 收货人信息 活动订单可不传在后续支付结果接口传入
     */
    private ReceiverUserParam receiverUserParam;

    /**
     * 来源 和orderType确定
     * 比如活动订单传入活动id
     * 比如传入上级订单号
     */
    @NotBlank(message = "订单来源不能为空")
    private String orderSource;

    /**
     * 活动订单的一些参数
     */
    private ActivityOrderCreateParam activityOrderCreateParam;

    /**
     * 终端环境
     */
    private String environment = UN_KNOW;

    /**
     * 用户信息相关
     */
    @NotNull(message = "用户信息不能为空")
    @Valid
    private UserParam userParam;

    /**
     * 商品相关
     */
    @NotEmpty(message = "商品不能为空")
    @Valid
    private List<GoodsParam> goodsParams;
}