package cn.com.duiba.cloud.order.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.order.center.api.model.dto.order.ExportOrderDTO;
import cn.com.duiba.cloud.order.center.api.model.dto.order.OrderDTO;
import cn.com.duiba.cloud.order.center.api.model.dto.order.OrderDetailDTO;
import cn.com.duiba.cloud.order.center.api.model.dto.order.OrderStatusCountDTO;
import cn.com.duiba.cloud.order.center.api.model.dto.order.OrderStatusDTO;
import cn.com.duiba.cloud.order.center.api.model.dto.order.SubOrderGoodsDTO;
import cn.com.duiba.cloud.order.center.api.model.dto.order.SubOrderPageDTO;
import cn.com.duiba.cloud.order.center.api.model.dto.order.UserOrderDetailDTO;
import cn.com.duiba.cloud.order.center.api.model.param.order.ExportOrderParam;
import cn.com.duiba.cloud.order.center.api.model.param.order.OrderDetailQueryParam;
import cn.com.duiba.cloud.order.center.api.model.param.order.OrderQueryParam;
import cn.com.duiba.cloud.order.center.api.model.param.order.OrderStatusCountParam;
import cn.com.duiba.cloud.order.center.api.model.param.order.SubOrderQueryParam;
import cn.com.duiba.cloud.order.center.api.model.param.order.UserOrderQueryParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * @Description 订单相关读操作接口
 * @Author dangcang
 * @Date 2021/11/10 1:37 下午
 **/
@AdvancedFeignClient
public interface RemoteOrderReadService {

    /**
     * 分页查询订单接口--后台
     * @param param
     * @return
     * @throws BizException
     */
    PageResponse<OrderDTO> backGroundMainOrderFind(OrderQueryParam param) throws BizException;

    /**
     * 分页查询订单接口-C端用户
     * @param param
     * @return
     * @throws BizException
     */
    PageResponse<OrderDTO> userOrderList(UserOrderQueryParam param) throws BizException;

    /**
     * 分页查询订单接口--后台
     * 子订单维度
     * @param param
     * @return
     * @throws BizException
     */
    PageResponse<SubOrderPageDTO> backGroundSubOrderFind(SubOrderQueryParam param) throws BizException;

    /**
     * 订单导出
     * @param param
     * @return
     * @throws BizException
     */
    ExportOrderDTO exportOrderList(ExportOrderParam param) throws BizException;

    /**
     * 获取订单详情--后台
     * @param param
     * @return
     * @throws BizException
     */
    OrderDetailDTO backgroundGetOrderDetail(OrderDetailQueryParam param) throws BizException;

    /**
     * 获取用户订单详情
     * @param param
     * @return
     * @throws BizException
     */
    UserOrderDetailDTO getUserOrderDetail(OrderDetailQueryParam param) throws BizException;

    /**
     * 后台获取订单状态下的订单数量
     * @param param
     * @return
     * @throws BizException
     */
    List<OrderStatusCountDTO> backGroundGetStatusCount(OrderStatusCountParam param) throws BizException;

    /**
     * 获取子订单信息列表
     * @param param
     * @param orderSortList
     * @return
     * @throws BizException
     */
    List<SubOrderGoodsDTO> getSubOrderList(OrderDetailQueryParam param, List<Long> orderSortList) throws BizException;

    /**
     * 根据订单号查询主订单状态
     * @param orderCodeList
     * @return
     * @throws BizException
     */
    List<OrderStatusDTO> getOrderStatusByOrderCodeList(List<String> orderCodeList) throws BizException;

}