package cn.com.duiba.cloud.order.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.order.center.api.model.dto.order.ConfirmOrderParam;
import cn.com.duiba.cloud.order.center.api.model.dto.order.PayDTO;
import cn.com.duiba.cloud.order.center.api.model.param.order.CancelOrderParam;
import cn.com.duiba.cloud.order.center.api.model.param.order.ExceptionHandleParam;
import cn.com.duiba.cloud.order.center.api.model.param.order.OrderAuditParam;
import cn.com.duiba.cloud.order.center.api.model.param.order.OrderCreateParam;
import cn.com.duiba.cloud.order.center.api.model.param.order.OrderRemarkParam;
import cn.com.duiba.cloud.order.center.api.model.param.order.OrderRemindParam;
import cn.com.duiba.cloud.order.center.api.model.param.order.PayResultParam;

/**
 * @Description 订单相关写操作接口
 * @Author dangcang
 * @Date 2021/11/10 1:35 下午
 **/
@AdvancedFeignClient
public interface RemoteOrderWriteService {

    /**
     * 创建订单
     * @param param
     * @return
     * @throws BizException
     */
    PayDTO createOrder(OrderCreateParam param) throws BizException;

    /**
     * 支付结果通知接口
     * @param param
     * @return
     * @throws BizException
     */
    Boolean payResult(PayResultParam param) throws BizException;

    /**
     * 立即支付
     * @param orderId
     * @return
     * @throws BizException
     */
    PayDTO payOrder(Long orderId) throws BizException;

    /**
     * 订单审核 主订单纬度
     * @param param
     * @return
     * @throws BizException
     */
    Boolean orderAudit(OrderAuditParam param) throws BizException;

    /**
     * 用户子订单备注
     * @param param
     * @return
     * @throws BizException
     */
    Boolean userOrderRemark(OrderRemarkParam param) throws BizException;

    /**
     * 订单确认
     * @param param
     * @return
     * @throws BizException
     */
    Boolean orderConfirm(ConfirmOrderParam param) throws BizException;

    /**
     * 租户订单备注
     * @param param
     * @return
     * @throws BizException
     */
    Boolean tenantOrderRemark(OrderRemarkParam param) throws BizException;

    /**
     * 取消订单
     * @param param
     * @return
     * @throws BizException
     */
    Boolean cancelOrder(CancelOrderParam param) throws BizException;

    /**
     * 用户提醒接口
     * @param param
     * @return
     * @throws BizException
     */
    Boolean userOrderRemind(OrderRemindParam param) throws BizException;

    /**
     * 异常订单处理
     * @param param
     * @return
     * @throws BizException
     */
    Boolean exceptionHandle(ExceptionHandleParam param) throws BizException;
}