/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.order.center.api.enums;

import cn.com.duiba.cloud.order.center.api.enums.OrderStatusEnum;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;

public enum SaleOrderAdapterStatusEnum {
    WAIT_PAY(1, "\u5f85\u652f\u4ed8", Lists.newArrayList((Object[])new Integer[]{OrderStatusEnum.WAIT_PAY.getStatus()})),
    WAIT_REVIEW(2, "\u5f85\u5ba1\u6838", Lists.newArrayList((Object[])new Integer[]{OrderStatusEnum.WAIT_REVIEW.getStatus()})),
    WAIT_SHIPMENT(3, "\u5f85\u53d1\u8d27", Lists.newArrayList((Object[])new Integer[]{OrderStatusEnum.WAIT_SHIPMENT.getStatus(), OrderStatusEnum.ORDER_ERROR.getStatus()})),
    WAIT_TAKE_DELIVERY(4, "\u5f85\u6536\u8d27", Lists.newArrayList((Object[])new Integer[]{OrderStatusEnum.WAIT_TAKE_DELIVERY.getStatus()})),
    ORDER_SUCCESS(5, "\u4ea4\u6613\u6210\u529f", Lists.newArrayList((Object[])new Integer[]{OrderStatusEnum.ORDER_COMPLETION.getStatus(), OrderStatusEnum.ORDER_SUCCESS.getStatus()})),
    ORDER_CLOSE(6, "\u4ea4\u6613\u5173\u95ed", Lists.newArrayList((Object[])new Integer[]{OrderStatusEnum.ORDER_CLOSE.getStatus()}));

    private Integer status;
    private String desc;
    private List<Integer> adapterStatus;

    private SaleOrderAdapterStatusEnum(Integer status, String desc, List<Integer> adapterStatus) {
        this.status = status;
        this.desc = desc;
        this.adapterStatus = adapterStatus;
    }

    public static SaleOrderAdapterStatusEnum getSaleOrderAdapterStatusEnum(OrderStatusEnum orderStatusEnum) {
        for (SaleOrderAdapterStatusEnum value : SaleOrderAdapterStatusEnum.values()) {
            if (!value.getAdapterStatus().contains(orderStatusEnum.getStatus())) continue;
            return value;
        }
        return null;
    }

    public static List<Integer> getOrderStatus(Integer saleOrderAdapterStatus) {
        for (SaleOrderAdapterStatusEnum value : SaleOrderAdapterStatusEnum.values()) {
            if (!Objects.equals(value.getStatus(), saleOrderAdapterStatus)) continue;
            return value.getAdapterStatus();
        }
        return null;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getDesc() {
        return this.desc;
    }

    public List<Integer> getAdapterStatus() {
        return this.adapterStatus;
    }
}

