package cn.com.duiba.cloud.order.center.api.enums;

import lombok.Getter;

/**
 * @Description 快递类型
 * @Author dangcang
 * @Date 2022/4/6 1:56 下午
 **/
@Getter
public enum DeliveryTypeEnum {

    NONE(1,"无需物流"),
    EXPRESS(2, "快递发货"),

    ;

    private Integer type;

    private String desc;

    DeliveryTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (DeliveryTypeEnum item : DeliveryTypeEnum.values()) {
            if (item.type == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static DeliveryTypeEnum valueOf(Integer value) {
        for (DeliveryTypeEnum param : values()) {
            if (param.getType().equals(value)) {
                return param;
            }
        }
        return null;
    }
}