package cn.com.duiba.cloud.order.center.api.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2022/5/25 9:30 下午
 **/
@Getter
public enum SourceTerminalTypeEnum {

    APP(1,  "app", "app"),
    WECHAT(2, "wechat_h5",  "微信H5"),
    WECHAT_MINI_PROGRAM(3, "wechat_mini_program",  "微信小程序"),
    ;

    private int id;
    private String code;
    private String desc;

    SourceTerminalTypeEnum(int id, String code, String desc) {
        this.id = id;
        this.code = code;
        this.desc = desc;
    }

    public static String getCodeById(Integer typeId) {
        if(null == typeId){
            return null;
        }
        for(SourceTerminalTypeEnum sourceTerminalType: SourceTerminalTypeEnum.values()){
            if(sourceTerminalType.getId() == typeId){
                return sourceTerminalType.getCode();
            }
        }
        return null;
    }

    public static String getByCode(String code) {
        for (SourceTerminalTypeEnum sourceTerminalType : SourceTerminalTypeEnum.values()) {
            if (Objects.equals(sourceTerminalType.getCode(), code)) {
                return sourceTerminalType.getDesc();
            }
        }
        return code;
    }
}