package cn.com.duiba.cloud.order.center.api.model.dto.order;

import cn.com.duiba.cloud.order.center.api.model.dto.virtual.RechargeGoodsDTO;
import cn.com.duiba.cloud.order.center.api.model.dto.virtual.VirtualGoodsDeliveryDTO;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2021/11/10 5:55 下午
 **/
@Data
@EqualsAndHashCode(callSuper = true)
public class SubOrderDetailDTO extends BaseGoodsDTO implements Serializable {

    private static final long serialVersionUID = 9082732128414348204L;

    /**
     * 是否售后
     */
    private Integer isAfterSale;

    /**
     * 售后状态
     */
    private Integer afterSaleStatus;

    /**
     * 支付项信息
     */
    private List<PaymentDTO> paymentDTOList;

    /**
     * 优惠项信息
     */
    private List<DiscountDTO> discountDTOList;

    /**
     * 实物商品特有信息
     */
    private PhysicalGoodsDTO physicalGoodsDTO;

    /**
     * 虚拟商品特有信息
     */
    private VirtualGoodsDeliveryDTO virtualGoodsDeliveryDTO;

    /**
     * 充值商品特有信息
     */
    private RechargeGoodsDTO rechargeGoodsDTO;
}